/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.common.FireAmmoAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import java.util.ArrayList;

public class ScrapLauncher
extends AbstractCard {
    public static final String ID = "ScrapLauncher";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("ScrapLauncher");
    public static final String NAME = "Scrap Launcher";
    public static final String DESCRIPTION = " Fire ALL Ammo in your hand.";
    private static final int COST = 3;
    private static final int POOL = 1;

    public ScrapLauncher() {
        super(ID, NAME, null, 3, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ENEMY, 1);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        ArrayList ammoInHand = (ArrayList)p.hand.getAmmo().group.clone();
        for (AbstractCard card : ammoInHand) {
            AbstractDungeon.actionManager.addToBottom(new FireAmmoAction(p, m, card));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new ScrapLauncher();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBaseCost(2);
        }
    }
}

